#include <iostream>
#include <iterator>
#include <list>

using namespace std;

class TSubject;

class IObserver { //Obserwator
public:
  virtual void update(TSubject* ) = 0;
  virtual ~IObserver() {};
};
//--------------------------------------------------------------
class TSubject { //Przedmiot
public:
  TSubject();
  virtual void attach(IObserver*); //docza (rejestruje) obiekty
                                   //klasy obserwator
  virtual void detach(IObserver*); //usuwa obiekty
                                   //klasy obserwator
  virtual void notify();           //powiadamia o wystpieniu zdarzenia
  virtual void setChange(); //rejestruje zmian stanu pojedynczego
                            //obiektu
private:
  list<IObserver*> observers;//dwukierunkowa lista obiektw
                             //klasy obserwator, list jest kontenerem
                             //dwukierunkowym
                             
  bool change;               //reprezentuje stan pojedynczego obiektu
};
//--------------------------------------------------------------
void TSubject::setChange() {
  change = true ;
}
//--------------------------------------------------------------
TSubject::TSubject(): change(false) {} //pocztkowo przedmiot
                                       //jest w stanie nieaktywnym
//--------------------------------------------------------------
void TSubject::attach (IObserver *o) {
  observers.push_back(o); //dodaje obserwatora na koniec kontenera
}
//--------------------------------------------------------------
void TSubject::detach (IObserver* o) {
  observers.remove(o);
}
//--------------------------------------------------------------
void TSubject::notify () {
  //powiadamia obserwatora o zmianie stanu
  if (change) {
    list<IObserver*>::iterator i = observers.begin();
    for ( ; i!= observers.end(); i++ ) {
      (*i)->update(this);
    }
    change = false;
  }
}
//--------------------------------------------------------------
class TUSBDevice: public TSubject {//konkretnym przedmiotem jest
                                    //urzdzenie USB
private:
  int report;
public:
  TUSBDevice();
  void readReport(); //odczytuje raport
  int getReport();  //zwraca wynik odczytu
};
//--------------------------------------------------------------
TUSBDevice::TUSBDevice() : report(0) {}
//--------------------------------------------------------------
void TUSBDevice::readReport() {
  report++;
  setChange();
}
//--------------------------------------------------------------
int TUSBDevice::getReport() {
  return report; //urzdzenie zwraca raport
}
//--------------------------------------------------------------
class TResultReadReport: public IObserver {//wynik odczytu jako
                                           //konkretny obserwator
  private:
    void update(TSubject*);
};
//--------------------------------------------------------------
void TResultReadReport::update(TSubject *o) {
  //polimorficzne rzutowanie czasu wykonania
  TUSBDevice *m = dynamic_cast<TUSBDevice *>(o);
  if (m) {
    cout << "R = " << m->getReport();
  }
}
//--------------------------------------------------------------
TUSBDevice *usbDevice;
IObserver *resultReadReport;
//--------------------------------------------------------------
int main()
{
  //konkretny przedmiot
  usbDevice = new TUSBDevice();
  //konkretny obserwator
  resultReadReport = new TResultReadReport();
  //doczenie (zarejestrowanie) konkretnego obserwatora
  usbDevice->attach(resultReadReport);
  for(int i = 0; i < 10; i++) {
    usbDevice->readReport();
    //powiadamia o odczycie
    usbDevice->notify();
    cout << endl;
  }
  //usunicie (wyrejestrowanie) konkretnego obserwatora
  usbDevice->detach(resultReadReport);
  delete usbDevice;
  delete resultReadReport;
  system("PAUSE");
  return 0;
}
//--------------------------------------------------------------
 
